<?php
    // require_once('session.php');
    include('Queries.php');
    include('WebRequests.php');
    require_once('functions.php');

    date_default_timezone_set('Africa/Johannesburg');
    

    if(!isset($_SESSION)) 
    {
        session_start();
    }

    if( !isset($_SESSION['login_user']) || ($_SESSION['login_user']==null) )
    {
        header("location:Login.php");
        exit();
    }

    $isPostBack = isPostBack();

    $today = date('Y-m-d', strtotime("Now"));
	
    // $error = "Error Lable-----" .$today;
    
    if( !isset($_POST['datepicker'] ) )
    {
        $Round = GetRoundNumber($today);
        $RoundDetails = GetRacesRound($Round, $today);
    }
    else
    {
        $today = $_POST['datepicker'];
        $Round = GetRoundNumber($_POST['datepicker']);
        $RoundDetails = GetRacesRound($Round, $today);

    }

    $ExtraPoints = GetExtraPoints($today, $Round);
    // html_show_array($ExtraPoints);
        
    if(array_key_exists("Back",$_POST))
    {
        goback();
    }

    function goback()
    {
        header("Location: AdminMenu.php");
        exit();
    }

    if(array_key_exists("Save",$_POST))
    {
        foreach($_POST as $key=>$val) 
        {
            //echo "The value of $key is $val <br>";
            if (strpos($key, 'txtUserName_') !== false) 
            {
                $values = explode("_",$key);
                $valueID = end($values);

                $newlable = 'chkbWasPresent_' .$valueID;

                $WasPresent  = false;
                if(isset($_POST[$newlable])) 
                {
                    $WasPresent  = true;
                }

                $newlable = 'chkbBillOverR140_' .$valueID;

                $BillOverR140  = false;
                if(isset($_POST[$newlable])) 
                {
                    $BillOverR140  = true;
                }

                $newlable = 'chkbWoreShirt_' .$valueID;

                $WoreShirt  = false;
                if(isset($_POST[$newlable])) 
                {
                    $WoreShirt  = true;
                }

                UpDateExtras($val, $today, $Round, $WasPresent
                , $BillOverR140, $WoreShirt);
            }
        } 
        
        
        $ExtraPoints = GetExtraPoints($today, $Round);
        
    }
    
?>


<!DOCTYPE html>
<html>
    <head>
        <title>Update Results </title>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">  
        <link rel="shortcut icon" media="screen,print" type="image/x-icon" href="images/favicon.ico" /> 

        <link rel="stylesheet" href="style/jquery-ui.css">
        <link rel="stylesheet" type="text/css" href="mystyles.css" 
                      media="screen" />  
        <!-- <style type="text/css">
            @viewport {
            width: device-width ;
            zoom: 1.0 ;
            } 

            @-ms-viewport {
            width: device-width ;
            }

            html {
                min-width: 100%;
                min-height: 100%;
            }

            body {
                height: 100px;
                font-family:Arial, Helvetica, sans-serif;
                font-size:14px;
                //background-image:url("images/cafeepaparazzi.jpg");
                background-repeat: no-repeat;
                //background-size:100% auto;
            }
            
            .style1
            {
                color: #FF0000;
            }
            .style2
            {
                width: 100%;
            }
            .style3
            {
                color: #3366FF;
            }
            .style5
            {
                color:black;
            }
            .style4
            {
                height: 8px;
                text-align: left;
            }

            .dropDownBox option
            {
                font-size:0.9em;
                background-color:#FF0 !important;
                display:block;
            }

            input[type=submit] 
            {
                font-size:Large;
                font-weight:bold;
                width:100%;
                background-color: #99CCFF;
                color: black;
                /* border: none;
                border-radius: 4px; */
                cursor: pointer;
                font-style: italic; 
            }

            input[type=submit]:hover 
            {
                background-color: #45a049;
            }


            table {
				border-collapse: collapse;   
			}

			.beta table, .beta th, .beta td {
				border: 1px solid black;
				height: 5px;
				text-align: left;
				padding: 1px;
                color: black;
			}
			
			.beta td.container {
				height: 5px;
			}
			
			.beta th {
				background-color: #4CAF50;
				color: white;
			}

            .beta tr:nth-child(even) {background-color: #f2f2f2;}

            #roundResults {border-collapse : collapse; border : 1px solid orange;}

            #container
            {
                width: 450px;
                height: 120px;
            }

            .maintable table, .maintable th, .maintable td {
				text-align: left;
				color: black;
                padding-top: 3px;
                padding-bottom: 3px;
			}

            .brandlogo
            {
                float: left;
                background-size: contain;
                background-image:url('images/BrandLogo.jpg');
                background-repeat: no-repeat;
                background-size: 100% 100%;
                width: 100%;
                height: 100%;
            }

            .brandlogo h1
            {
                text-align: center;
                text-shadow: 3px 2px black;
                color: #999999;
                font-style: italic; 
                //font-size: 15px;
                margin-top: 0px; 
                margin-bottom: 1px; 
            }

            /* On smaller screens, decrease text size */
            @media only screen and (max-width: 50px) {
            .prev, .next,.text {font-size: 11px}
            }

        </style> -->

        <script src="scripts/jquery.min.js"></script>
        <!--<script src="https://code.jquery.com/jquery-1.12.4.js"></script>-->
        <script src="scripts/jquery-ui.js"></script>

        <script language="javascript" type="text/javascript">
            $( function() {
                $( "#datepicker" ).datepicker({
                    showOn: "button",
                    currentText: "Now",
                    navigationAsDateFormat: true,
                    gotoCurrent: true,
                    buttonImage: "images/Calendar.png",
                    buttonImageOnly: true,
                    buttonText: "Select date",
                    dateFormat: "yy-mm-dd",
                    // altField: "#datepickeralternate",
                    // altFormat: "DD, d MM, yy",
                    showWeek: true,
                    firstDay: 1,
                    onSelect: function() {
                        
                        },
                    onClose: function(dateTime, id){
                            var id = dateTime; 
                            //var id = $(this).attr("id");
                            //alert(id); 
                            document.frmUpdateResults.refresh.click();
                        }
                  });
            } );

            function myFunction() 
            {
                //alert ("hello");
                //var theform = document.changer.SetEnabledPictures
                document.getElementById("SaveSelection").style.backgroundColor = "LimeGreen";
            } 

        </script>
	
    </head>
   
   
    <meta name="viewport" content="width=device-width, initial-scale=1.0">  
    <body >
        <form id="frmUpdateResults" name="frmUpdateResults" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
	
            <div id="container">
                <div class="brandlogo">
                    <h1 class="Header">Welcome <?php if( isset($login_session) && ($login_session!==null) )
                                    {echo $_SESSION['user_name']; }
                                    ?></h1>
                </div>
            </div>

            <table  class="maintable">
                <col width="25%">
                <col width="74%">
                <tr>
                    <td class="style16" colspan="2">
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <strong><span class="style3"><span class="style13">Round</span>&nbsp;</span></strong></td>
                </tr>

                <tr>
                    <td class="style2" colspan="2">
                       
                    </td>
                </tr>

                <tr>
                    <td align="right" class="style6">
                        <strong>Selected Date:</strong></td>
                    <td>
                        <input type="text" id="datepicker" style = "float: left;width:30%;"  name="datepicker" value="<?php echo ($today);?> "/>
                        <input type = "submit" id="datepickeralternate" style = "float: right; width:50%;"  name="refresh" value = "Refresh" method="post"> 
                    </td>
                </tr>

                <tr>
                    <td align="right" class="style6">
                        <strong>Round:</strong></td>
                    <td>
                        <div class="style3">
                            <input type="text" name="round" style = "float: left;width:5%;" value="<?php echo ($Round);?> " size="4" readonly>           
                            <input type="text" name="roundDetail" style = "float: left;width:92%;" value="<?php 
                            foreach ($RoundDetails as $key => $val) 
                            {
                                $mName = $val['Race'];
                                $mVenue = $val['Venue'];
                                $mDate = $val['Date'];
                                $mTime = $val['Time'];
                            } 
                            echo (utf8_encode($mName) ."---" 
                            .utf8_encode($mVenue) ."---" 
                            .utf8_encode($mDate)." " 
                            .utf8_encode($mTime));?> " size="50" readonly>  
                        </div>

                    </td>
                </tr>

                <tr>
                    <td align="right" class="style6">
                        <strong>Extra Per User:</strong></td>
                    <td>
                        <div class="style3">
                            <table name="roundResults" class="beta" style="display: inline-block; color: black; border: 1px solid;">
                                <col width="20">
                                <col width="0">
                                <col width="50">
                                <col width="20">
                                <col width="20">
                                <col width="20">
                                <tr class="header">
									<th>Round</th>
									<th></th>
                                    <th>Name</th>
                                    <th>Was Present</th>
                                    <th>Bill Over R140</th>
                                    <th>Wore Shirt</th>
								</tr>

                                <?php
                                    if( isset($ExtraPoints) && ($ExtraPoints !==false) )
                                    {
                                        $nID = 0;
                                        foreach ($ExtraPoints as $key => $val) 
                                        {
                                            $mName = $val['NAME'];
                                            $mUserName = $val['UserName'];
                                            $mRound = $val['Round'];
                                            $mWasPresent = $val['rWasPresent'];
                                            $mrBillOverR140 = $val['rBillOverR140'];
                                            $mrWoreShirt = $val['rWoreShirt'];
                                            
                                            echo "<tr>";
                                            echo "<td>".$mRound."</td>";
                                            //echo "<td>".utf8_encode($mUserName)."</td>";
                                            echo "<td > <input type='hidden' readonly name='txtUserName_".$nID ."' value='".utf8_encode($mUserName)."' ></td>";
                                           //echo "<td>".utf8_encode($mName)."</td>";
                                            echo "<td> <input type='text' readonly name='txtName_".$nID ."' value='".utf8_encode($mName)."'></td>";
                                            
                                            if ($mWasPresent == 1)
                                            {
                                                echo '<td><input type="checkbox" name="chkbWasPresent_'.$nID .'" value="1" checked="checked" id="checkbox" onclick="myFunction();" /></td>';                                           
                                            }
                                            else
                                            {
                                                echo '<td><input type="checkbox" name="chkbWasPresent_'.$nID .'" value="0" id="checkbox" onclick="myFunction();" /></td>';                                           
                                            }


                                            if ($mrBillOverR140 == 1)
                                            {
                                                echo '<td><input type="checkbox" name="chkbBillOverR140_'.$nID .'" value="1" checked="checked" id="checkbox" onclick="myFunction();" /></td>';                                           
                                            }
                                            else
                                            {
                                                echo '<td><input type="checkbox" name="chkbBillOverR140_'.$nID .'" value="0" id="checkbox" onclick="myFunction();" /></td>';                                           
                                            }

                                            if ($mrWoreShirt == 1)
                                            {
                                                echo '<td><input type="checkbox" name="chkbWoreShirt_'.$nID .'" value="1" checked="checked" id="checkbox" onclick="myFunction();" /></td>';                                           
                                            }
                                            else
                                            {
                                                echo '<td><input type="checkbox" name="chkbWoreShirt_'.$nID .'" value="0" id="checkbox" onclick="myFunction();" /></td>';                                           
                                            }

                                            $nID = $nID + 1;
                                        }
                                    }
                                ?>
                            </table>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td align="right" class="style6">
                        <strong>Save Results:</strong></td>
                    <td>
                    
                    <?php
                    if ($_SESSION['IsAdmin']  == 0)
                    {
                        echo '<input disabled type = "submit" id="SaveSelection" name="Save" value = "Save Only Admins" method="post"/>';                      
                    }
                    else
                    {
                        echo '<input type = "submit" id="SaveSelection" name="Save" value = "Save" method="post"/>';                      
                    }
                    
                    ?>
                    </td>
                </tr>

                <tr>
                    <td align="right" class="style6">
                        <strong>Back:</strong></td>
                    <td>
                        <div class="style3">
                        <input type = "submit" id="Back" name="Back" value = "Back" method="post"/>   
                        </div>

                    </td>
                </tr>
            </table>
            
        </form>
    </body>
   
</html>
