<?php
/**
 * excel_xml
 * 
 * @author Gianluca Zanferrari, <zanferrari@gmail.com>
 * @version 1.0
 */
class excel_xml{
    
    var $xml;
    var $row;
    
    /**
     * Initiate the class and sets the xml template
     */
    function __construct(){
        
        $this->xml = <<<EOD
<?xml version="1.0"?>
<?mso-application progid="Excel.Sheet"?>
<Workbook
  xmlns:x="urn:schemas-microsoft-com:office:excel"
  xmlns="urn:schemas-microsoft-com:office:spreadsheet"
  xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">
<Styles>
 <Style ss:ID="Default" ss:Name="Normal">
  <Alignment ss:Vertical="Bottom"/>
  <Borders/>
  <Font/>
  <Interior/>
  <NumberFormat/>
  <Protection/>
 </Style>
 <Style ss:ID="s27">
  <Font x:Family="Swiss" ss:Color="{TitleColor}" ss:Bold="1"/>
 </Style>
 <Style ss:ID="s21">
  <NumberFormat ss:Format="yyyy\-mm\-dd"/>
 </Style>
 <Style ss:ID="s22">
  <NumberFormat ss:Format="yyyy\-mm\-dd\ hh:mm:ss"/>
 </Style>
 <Style ss:ID="s23">
  <NumberFormat ss:Format="hh:mm:ss"/>
 </Style>
</Styles>

 <Worksheet ss:Name="Sheet1">
  <ss:Table>
    {titles}
    {rows}
  </ss:Table>
 </Worksheet>
</Workbook>
EOD;
        
    }
    
    /**
     * Optional: sets the first row as titles of the spreadsheet columns
     * 
     * @param array $t
     */
    function set_titles($t = array(), $Color = NULL)
    {
        if(is_null($Color))
        {
            $Color = 'Black';
        }
        $this->xml = str_replace('{TitleColor}', $Color, $this->xml);
        $titles = '<ss:Row>'.chr(10);
        
        foreach($t as $key=>$val) {
            
            $titles .= '<ss:Cell ss:StyleID="s27"><Data ss:Type="String">'.$val.'</Data></ss:Cell>'.chr(10);
            
        }
        
        $titles .= '</ss:Row>'.chr(10);
        
        // replaces de placeholder {titles} with the passed values
        $this->xml = str_replace('{titles}', $titles, $this->xml);
        
    }
    
    /**
     * Sets a row of data
     * 
     * @param array $d
     */
    function add_row($d = array()){
        
       $this->row .= '<ss:Row>'.chr(10);
        
        foreach($d as $key=>$val){
                                          
            (is_numeric($val)) ? $p = 'Number' : $p = 'String';
            
            // date check yyyy-mm-dd for setting style
            if(preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$val)){
                
                $s = ' ss:StyleID="s21"';
                
            }elseif(preg_match("/^([0-9]{4})-([0-1][0-9])-([0-3][0-9])\s([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9])$/",$val)){// timestamp check yyyy-mm-dd hh:mm:ss  for setting style
                
                $s = ' ss:StyleID="s22"';
                
            }elseif(preg_match("/^([01]\d|2[0-3]):([0-5]\d|60):([0-5]\d|60)$/",$val)) {// time check hh:mm:ss  for setting style
                
                $s = ' ss:StyleID="s23"';
            
            }else{
                
                $s = NULL;
                
            }
                
            $this->row .= '<ss:Cell'.$s.'><Data ss:Type="'.$p.'">'.htmlentities($val).'</Data></ss:Cell>'.chr(10);

        }
        
        $this->row .= '</ss:Row>'.chr(10); 
        
    }
    
    /**
     * Send the result to browser if no param is passed
     * Write the result to a file if a filename (extention not needed) is passed
     * 
     * @param string $opt
     */
    function output($opt = NULL){
        
        // removes {titles} from template if not earlier set
        $this->xml = str_replace('{titles}', '', $this->xml);
        
        // replaces de placeholder {rows} with the rows of data
        $this->xml = str_replace('{rows}', $this->row, $this->xml);
        
        // output to browser
        if(is_null($opt)){
            
            header("Pragma: public");
            header("Expires: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-type: application/vnd.ms-excel");
            header("Content-Disposition: attachment;filename=excel_xml_output.xls");
            echo($this->xml);
            
        // writes to file
        }else{
                    
            file_put_contents($opt.'.xml', $this->xml);
            
        }
        
    }

    function outputXLS($opt = NULL)
    {
        // removes {titles} from template if not earlier set
        $this->xml = str_replace('{titles}', '', $this->xml);
        
        // replaces de placeholder {rows} with the rows of data
        $this->xml = str_replace('{rows}', $this->row, $this->xml);
        
        // output to browser
        if(!is_null($opt)){
            
            header("Pragma: public");
            header("Expires: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-type: application/vnd.ms-excel");
            header("Content-Disposition: attachment;filename=$opt");
            echo($this->xml);
            
        }
        
    }
    
}
    
?>